---
title: Device compatibility · Cloudflare One docs
description: Magic WAN is compatible with any device that supports IPsec with
  the supported configuration parameters or supports GRE.
lastUpdated: 2025-11-04T17:07:51.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/reference/device-compatibility/
  md: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/reference/device-compatibility/index.md
---

Magic WAN is compatible with any device that supports IPsec with the [supported configuration parameters](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/reference/gre-ipsec-tunnels/#supported-configuration-parameters) or supports GRE.

The matrix below includes example devices and links to the integration guides.

| Appliance | GRE tunnel | IPsec tunnel |
| - | - | - |
| [Aruba EdgeConnect](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/third-party/aruba-edgeconnect/) | ✅ | ✅ |
| Cisco ASA | Compatibility on roadmap | Specifications compatible[1](#user-content-fn-1) |
| [Cisco IOS XE](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/third-party/cisco-ios-xe/) | ✅ | ✅ |
| Cisco Meraki | Compatibility on roadmap | Compatibility on roadmap |
| [Cisco SD-WAN](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/third-party/viptela/) | ✅ | ✅ |
| [Fortinet](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/third-party/fortinet/) | Specifications compatible[1](#user-content-fn-1) | ✅ |
| [Furukawa Electric FITELnet](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/third-party/fitelnet/) | - | ✅ |
| [Juniper Networks SRX Series Firewalls](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/third-party/juniper/) | - | ✅ |
| [Palo Alto Networks Next-Generation Firewall](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/third-party/palo-alto/) | ✅ | ✅ |
| [pfSense](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/third-party/pfsense/) | ✅ | ✅ |
| Prisma SD-WAN (Palo Alto) | Specifications compatible[1](#user-content-fn-1) | Specifications compatible[1](#user-content-fn-1) |
| Riverbed | Specifications compatible[1](#user-content-fn-1) | Specifications compatible[1](#user-content-fn-1) |
| [SonicWall](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/third-party/sonicwall/) | - | ✅ |
| [Sophos Firewall](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/third-party/sophos-firewall/) | ✅ | ✅ |
| [strongSwan](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/third-party/strongswan/) | - | ✅ |
| Velocloud | Compatibility on roadmap | Compatibility on roadmap |
| Versa | Specifications compatible[1](#user-content-fn-1) | Compatibility on roadmap |
| [VyOS](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/third-party/vyos/) | ✅ | ✅ |

| VPN | GRE tunnel | IPsec tunnel |
| - | - | - |
| [Alibaba Cloud VPN Gateway](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/third-party/alibaba-cloud/) | - | ✅ |
| [Amazon AWS Transit Gateway](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/third-party/aws/) | - | ✅ |
| [Azure VPN Gateway](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/third-party/azure/) | - | ✅ |
| [GCP Cloud VPN](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/third-party/google/) | - | ✅ |
| [Oracle Cloud](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/third-party/oracle/) | - | ✅ |

## Footnotes

1. Specifications compatible per vendor documentation [↩](#user-content-fnref-1) [↩2](#user-content-fnref-1-2) [↩3](#user-content-fnref-1-3) [↩4](#user-content-fnref-1-4) [↩5](#user-content-fnref-1-5) [↩6](#user-content-fnref-1-6) [↩7](#user-content-fnref-1-7)
